/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.io;

import com.aptana.core.epl.IMemento;
import com.aptana.core.io.vfs.VirtualConnectionManager;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.FeatureEvent;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.UsagePlugin;
import java.net.URI;
import java.util.UUID;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class ConnectionPoint
extends PlatformObject
implements IConnectionPoint,
IExecutableExtension {
    private static final String ELEMENT_NAME = "name";
    private String id;
    private String type;
    private boolean dirty;
    private String name;

    protected ConnectionPoint(String type) {
        this.type = type;
        this.setId(UUID.randomUUID().toString());
    }

    protected ConnectionPoint() {
        this("");
    }

    public final void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.setType(config.getAttribute("id"));
    }

    protected boolean isPersistent() {
        return true;
    }

    protected void loadState(IMemento memento) {
        IMemento child = memento.getChild(ELEMENT_NAME);
        if (child != null) {
            this.name = child.getTextData();
        }
    }

    protected void saveState(IMemento memento) {
        memento.createChild(ELEMENT_NAME).putTextData(this.name);
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
        VirtualConnectionManager.getInstance().register(this);
    }

    public final String getType() {
        return this.type;
    }

    private final void setType(String type) {
        this.type = type;
    }

    protected final void notifyChanged() {
        this.dirty = true;
    }

    final boolean isChanged() {
        try {
            boolean bl = this.dirty;
            return bl;
        }
        finally {
            this.dirty = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyChanged();
    }

    public URI getRootURI() {
        return VirtualConnectionManager.getInstance().getConnectionVirtualURI(this);
    }

    public IFileStore getRoot() throws CoreException {
        return EFS.getStore((URI)this.getRootURI());
    }

    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connect(false, monitor);
    }

    public void connect(boolean force, IProgressMonitor monitor) throws CoreException {
        this.sendEvent(new FeatureEvent("remote.connect." + this.getType(), null));
    }

    private void sendEvent(FeatureEvent featureEvent) {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return;
        }
        IStudioAnalytics analytics = plugin.getStudioAnalytics();
        if (analytics == null) {
            return;
        }
        analytics.sendEvent((AnalyticsEvent)featureEvent);
    }

    public boolean isConnected() {
        return true;
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect(IProgressMonitor monitor) throws CoreException {
    }

    public Object getAdapter(Class adapter) {
        if (IFileStore.class.equals((Object)adapter)) {
            try {
                return this.getRoot();
            }
            catch (CoreException e) {
                return null;
            }
        }
        return super.getAdapter(adapter);
    }

    public String toString() {
        return this.getName();
    }
}

